/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.client.LOTRReflectionClient;
import lotr.client.gui.LOTRGuiMenuBase;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRTitle;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketSelectTitle;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LOTRGuiTitles
extends LOTRGuiMenuBase {
    private LOTRTitle.PlayerTitle currentTitle;
    private List<LOTRTitle> displayedTitles = new ArrayList<LOTRTitle>();
    private Map<LOTRTitle, Pair<Boolean, Pair<Integer, Integer>>> displayedTitleInfo = new HashMap<LOTRTitle, Pair<Boolean, Pair<Integer, Integer>>>();
    private LOTRTitle selectedTitle;
    private EnumChatFormatting selectedColor = EnumChatFormatting.WHITE;
    private int colorBoxWidth = 8;
    private int colorBoxGap = 4;
    private Map<EnumChatFormatting, Pair<Integer, Integer>> displayedColorBoxes = new HashMap<EnumChatFormatting, Pair<Integer, Integer>>();
    private GuiButton selectButton;
    private GuiButton removeButton;
    private float currentScroll = 0.0f;
    private boolean isScrolling = false;
    private boolean wasMouseDown;
    private int scrollBarWidth = 11;
    private int scrollBarHeight = 144;
    private int scrollBarX = 197 - (this.scrollBarWidth - 1) / 2;
    private int scrollBarY = 30;
    private int scrollWidgetWidth = 11;
    private int scrollWidgetHeight = 8;

    @Override
    public void func_73866_w_() {
        this.xSize = 256;
        super.func_73866_w_();
        this.selectButton = new GuiButton(0, this.guiLeft + this.xSize / 2 - 10 - 80, this.guiTop + 220, 80, 20, StatCollector.func_74838_a((String)"lotr.gui.titles.select"));
        this.field_146292_n.add(this.selectButton);
        this.removeButton = new GuiButton(1, this.guiLeft + this.xSize / 2 + 10, this.guiTop + 220, 80, 20, StatCollector.func_74838_a((String)"lotr.gui.titles.remove"));
        this.field_146292_n.add(this.removeButton);
        this.func_73876_c();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.currentTitle = LOTRLevelData.getData((EntityPlayer)this.field_146297_k.field_71439_g).getPlayerTitle();
        this.displayedTitles.clear();
        ArrayList<LOTRTitle> availableTitles = new ArrayList<LOTRTitle>();
        ArrayList<LOTRTitle> unavailableTitles = new ArrayList<LOTRTitle>();
        for (LOTRTitle title : LOTRTitle.allTitles) {
            if (title.canPlayerUse((EntityPlayer)this.field_146297_k.field_71439_g)) {
                availableTitles.add(title);
                continue;
            }
            if (!title.canDisplay((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            unavailableTitles.add(title);
        }
        Comparator<LOTRTitle> sorter = LOTRTitle.createTitleSorter((EntityPlayer)this.field_146297_k.field_71439_g);
        Collections.sort(availableTitles, sorter);
        Collections.sort(unavailableTitles, sorter);
        this.displayedTitles.addAll(availableTitles);
        this.displayedTitles.add(null);
        this.displayedTitles.addAll(unavailableTitles);
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupScrollBar(i, j);
        String s = StatCollector.func_74838_a((String)"lotr.gui.titles.title");
        this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.guiTop - 30, 0xFFFFFF);
        String titleName = this.currentTitle == null ? StatCollector.func_74838_a((String)"lotr.gui.titles.currentTitle.none") : this.currentTitle.getTitle().getDisplayName((EntityPlayer)this.field_146297_k.field_71439_g);
        EnumChatFormatting currentColor = this.currentTitle == null ? EnumChatFormatting.WHITE : this.currentTitle.getColor();
        titleName = currentColor + titleName + EnumChatFormatting.RESET;
        this.drawCenteredString(StatCollector.func_74837_a((String)"lotr.gui.titles.currentTitle", (Object[])new Object[]{titleName}), this.guiLeft + this.xSize / 2, this.guiTop, 0xFFFFFF);
        this.displayedTitleInfo.clear();
        int titleX = this.guiLeft + this.xSize / 2;
        int titleY = this.guiTop + 30;
        int yIncrement = 12;
        this.func_73728_b(titleX - 70, titleY - 1, titleY + yIncrement * 12, -1711276033);
        this.func_73728_b(titleX + 70 - 1, titleY - 1, titleY + yIncrement * 12, -1711276033);
        int size = this.displayedTitles.size();
        int min = 0 + Math.round(this.currentScroll * (float)(size - 12));
        int max = 11 + Math.round(this.currentScroll * (float)(size - 12));
        min = Math.max(min, 0);
        max = Math.min(max, size - 1);
        for (int index = min; index <= max; ++index) {
            int mouseOver;
            String name;
            boolean isCurrentTitle;
            LOTRTitle title = this.displayedTitles.get(index);
            boolean bl = isCurrentTitle = this.currentTitle != null && this.currentTitle.getTitle() == title;
            if (title != null) {
                name = title.getDisplayName((EntityPlayer)this.field_146297_k.field_71439_g);
                if (isCurrentTitle) {
                    name = "[" + name + "]";
                    name = this.currentTitle.getColor() + name;
                }
            } else {
                name = "---";
            }
            int nameWidth = this.field_146289_q.func_78256_a(name);
            int nameHeight = this.field_146297_k.field_71466_p.field_78288_b;
            int nameXMin = titleX - nameWidth / 2;
            int nameXMax = titleX + nameWidth / 2;
            int nameYMin = titleY;
            int nameYMax = titleY + nameHeight;
            int n = mouseOver = i >= nameXMin && i < nameXMax && j >= nameYMin && j < nameYMax ? 1 : 0;
            if (title != null) {
                this.displayedTitleInfo.put(title, (Pair<Boolean, Pair<Integer, Integer>>)Pair.of((Object)(mouseOver != 0), (Object)Pair.of((Object)titleX, (Object)titleY)));
            }
            int textColor = title != null ? (title.canPlayerUse((EntityPlayer)this.field_146297_k.field_71439_g) ? (mouseOver != 0 ? 0xFFFFA0 : 0xFFFFFF) : (mouseOver != 0 ? 0xBBBBBB : 0x777777)) : 0x777777;
            this.drawCenteredString(name, titleX, titleY, textColor);
            titleY += yIncrement;
        }
        this.displayedColorBoxes.clear();
        if (this.selectedTitle != null) {
            String title = this.selectedColor + this.selectedTitle.getDisplayName((EntityPlayer)this.field_146297_k.field_71439_g);
            this.drawCenteredString(title, this.guiLeft + this.xSize / 2, this.guiTop + 185, 0xFFFFFF);
            ArrayList<EnumChatFormatting> colorCodes = new ArrayList<EnumChatFormatting>();
            for (EnumChatFormatting ecf : EnumChatFormatting.values()) {
                if (!ecf.func_96302_c()) continue;
                colorCodes.add(ecf);
            }
            int colorX = this.guiLeft + this.xSize / 2 - (this.colorBoxWidth * colorCodes.size() + this.colorBoxGap * (colorCodes.size() - 1)) / 2;
            int colorY = this.guiTop + 200;
            for (EnumChatFormatting code : colorCodes) {
                int color = LOTRReflectionClient.getFormattingColor(code);
                float[] rgb = new Color(color).getColorComponents(null);
                GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                boolean mouseOver = i >= colorX && i < colorX + this.colorBoxWidth && j >= colorY && j < colorY + this.colorBoxWidth;
                GL11.glDisable((int)3553);
                this.func_73729_b(colorX, colorY + (mouseOver ? -1 : 0), 0, 0, this.colorBoxWidth, this.colorBoxWidth);
                GL11.glEnable((int)3553);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.displayedColorBoxes.put(code, (Pair<Integer, Integer>)Pair.of((Object)colorX, (Object)colorY));
                colorX += this.colorBoxWidth + this.colorBoxGap;
            }
        }
        if (this.displayedTitles.size() > 12) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int scroll = (int)(this.currentScroll * (float)(this.scrollBarHeight - this.scrollWidgetHeight));
            int x1 = this.guiLeft + this.scrollBarX;
            int y1 = this.guiTop + this.scrollBarY + scroll;
            int x2 = x1 + this.scrollWidgetWidth;
            int y2 = y1 + this.scrollWidgetHeight;
            Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)-1426063361);
        }
        this.selectButton.field_146124_l = this.selectedTitle != null;
        this.removeButton.field_146124_l = this.currentTitle != null;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(i, j, f);
        for (Map.Entry<LOTRTitle, Pair<Boolean, Pair<Integer, Integer>>> entry : this.displayedTitleInfo.entrySet()) {
            LOTRTitle title = entry.getKey();
            String desc = title.getDescription((EntityPlayer)this.field_146297_k.field_71439_g);
            titleX = (Integer)((Pair)entry.getValue().getRight()).getLeft();
            titleY = (Integer)((Pair)entry.getValue().getRight()).getRight();
            boolean mouseOver = (Boolean)entry.getValue().getLeft();
            if (!mouseOver) continue;
            int stringWidth = 200;
            List titleLines = this.field_146289_q.func_78271_c(desc, stringWidth);
            int offset = 10;
            int x = i + offset;
            int y = j + offset;
            this.func_146283_a(titleLines, x, y);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void setupScrollBar(int i, int j) {
        boolean isMouseDown = Mouse.isButtonDown((int)0);
        int i1 = this.guiLeft + this.scrollBarX;
        int j1 = this.guiTop + this.scrollBarY;
        int i2 = i1 + this.scrollBarWidth;
        int j2 = j1 + this.scrollBarHeight;
        if (!this.wasMouseDown && isMouseDown && i >= i1 && j >= j1 && i < i2 && j < j2) {
            this.isScrolling = true;
        }
        if (!isMouseDown) {
            this.isScrolling = false;
        }
        this.wasMouseDown = isMouseDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(j - j1) - (float)this.scrollWidgetHeight / 2.0f) / ((float)(j2 - j1) - (float)this.scrollWidgetHeight);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button == this.selectButton && (this.currentTitle == null || this.selectedTitle != this.currentTitle.getTitle() || this.selectedColor != this.currentTitle.getColor())) {
                LOTRPacketSelectTitle packet = new LOTRPacketSelectTitle(new LOTRTitle.PlayerTitle(this.selectedTitle, this.selectedColor));
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else if (button == this.removeButton) {
                LOTRPacketSelectTitle packet = new LOTRPacketSelectTitle(null);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else {
                super.func_146284_a(button);
            }
        }
    }

    protected void func_73864_a(int i, int j, int mouse) {
        if (mouse == 0) {
            for (Map.Entry<LOTRTitle, Pair<Boolean, Pair<Integer, Integer>>> entry : this.displayedTitleInfo.entrySet()) {
                LOTRTitle title = entry.getKey();
                boolean mouseOver = (Boolean)entry.getValue().getLeft();
                if (!mouseOver || !title.canPlayerUse((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
                this.selectedTitle = title;
                this.selectedColor = EnumChatFormatting.WHITE;
                return;
            }
            if (!this.displayedColorBoxes.isEmpty()) {
                for (Map.Entry<LOTRTitle, Object> entry : this.displayedColorBoxes.entrySet()) {
                    EnumChatFormatting color = (EnumChatFormatting)entry.getKey();
                    int colorX = (Integer)((Pair)entry.getValue()).getLeft();
                    int colorY = (Integer)((Pair)entry.getValue()).getRight();
                    if (i < colorX || i >= colorX + this.colorBoxWidth || j < colorY || j >= colorY + this.colorBoxWidth) continue;
                    this.selectedColor = color;
                    break;
                }
            }
        }
        super.func_73864_a(i, j, mouse);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            i = Integer.signum(i);
            int j = this.displayedTitles.size() - 12;
            this.currentScroll -= (float)i / (float)j;
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
    }
}

